// Service Worker – cache del shell
const CACHE_NAME='radio-shell-v1';
const SHELL_ASSETS=[
  './',
  './index.php',
  './manifest.php',
  'icon-192.png',
  'icon-512.png',
  'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css',
  'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js',
  'https://kit.fontawesome.com/08c7c8fb48.js'
];

// Instala
self.addEventListener('install',e=>{
  e.waitUntil(caches.open(CACHE_NAME).then(c=>c.addAll(SHELL_ASSETS)));
  self.skipWaiting();
});

// Activa
self.addEventListener('activate',e=>{
  e.waitUntil(caches.keys().then(keys=>
    Promise.all(keys.filter(k=>k!==CACHE_NAME).map(k=>caches.delete(k)))
  ));
  self.clients.claim();
});

// Cache-First (excepto streaming)
self.addEventListener('fetch',e=>{
  const url=new URL(e.request.url);
  if(url.searchParams.has('port')) return;           // no cachear el stream
  e.respondWith(caches.match(e.request).then(r=>r||fetch(e.request)));
});
